<?php
/**
 * Plugin Name: Got A Sale - Order Notifications for WooCommerce
 * Plugin URI: https://gotasale.io
 * Description: Send WooCommerce order notifications to Telegram, Discord, and Slack.
 * Version: 1.1.2
 * Author: Got A Sale
 * Author URI: https://empyreal.au
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: got-a-sale
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * WC requires at least: 6.0
 * WC tested up to: 9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Plugin constants
define( 'GOTASALE_VERSION', '1.1.2' );
define( 'GOTASALE_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'GOTASALE_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
if ( ! defined( 'GOTASALE_API_URL' ) ) {
	define( 'GOTASALE_API_URL', 'https://api.gotasale.io' );
}
if ( ! defined( 'GOTASALE_LANDING_URL' ) ) {
	define( 'GOTASALE_LANDING_URL', 'https://gotasale.io' );
}

// Activation / Deactivation
require_once GOTASALE_PLUGIN_DIR . 'includes/class-gotasale-activator.php';
require_once GOTASALE_PLUGIN_DIR . 'includes/class-gotasale-deactivator.php';
require_once GOTASALE_PLUGIN_DIR . 'includes/class-gotasale-wc-api.php';

register_activation_hook( __FILE__, array( 'GotASale_Activator', 'activate' ) );
register_deactivation_hook( __FILE__, array( 'GotASale_Deactivator', 'deactivate' ) );

// Declare HPOS (High-Performance Order Storage) compatibility
add_action( 'before_woocommerce_init', function() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

// Boot the plugin
require_once GOTASALE_PLUGIN_DIR . 'includes/class-gotasale.php';

/**
 * Returns the main plugin instance.
 */
function gotasale() {
	return GotASale::instance();
}

add_action( 'plugins_loaded', 'gotasale' );

// WC API key setup cron hooks
add_action( 'gotasale_wc_api_setup_retry', array( 'GotASale_WC_API', 'setup' ) );

// Try WC API setup on admin init if registration done but API not yet configured
add_action( 'admin_init', function() {
	$reg = get_option( 'gotasale_registration_status', array() );
	if ( isset( $reg['status'] ) && 'registered' === $reg['status'] && ! GotASale_WC_API::is_configured() ) {
		GotASale_WC_API::setup();
	}
} );
