<?php
/**
 * Admin settings page template — branded dashboard.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$gotasale_site_token          = get_option( 'gotasale_site_token', '' );
$gotasale_plan_status         = get_option( 'gotasale_plan_status', array( 'tier' => 'free' ) );
$gotasale_tier                = isset( $gotasale_plan_status['tier'] ) ? $gotasale_plan_status['tier'] : 'free';
$gotasale_registration_status = get_option( 'gotasale_registration_status', array() );
$gotasale_reg_state           = isset( $gotasale_registration_status['status'] ) ? $gotasale_registration_status['status'] : '';
$gotasale_license_key         = get_option( 'gotasale_license_key', '' );
$gotasale_wc_api_configured   = GotASale_WC_API::is_configured();
$gotasale_wc_permissions      = get_option( 'gotasale_wc_permissions', 'read' );
?>

<div class="wrap">
	<h1>Got A Sale</h1>

	<div class="gotasale-settings" data-theme="dark">

	<!-- 0. Theme Toggle -->
	<div class="gotasale-theme-toggle">
		<span class="gotasale-theme-toggle__label" id="gotasale-theme-icon">&#9790;</span>
		<button type="button" class="gotasale-theme-toggle__switch" id="gotasale-theme-switch" title="<?php esc_attr_e( 'Toggle light/dark theme', 'got-a-sale' ); ?>"></button>
	</div>

	<!-- 1. Brand Header -->
	<div class="gotasale-brand-header">
		<div class="gotasale-brand-wordmark">
			gotasale<span class="gotasale-brand-dot"></span>
		</div>
		<span class="gotasale-tier-badge gotasale-tier-badge--<?php echo esc_attr( $gotasale_tier ); ?>">
			<?php echo esc_html( ucfirst( $gotasale_tier ) ); ?>
		</span>
	</div>

	<!-- 2. Registration Warning (conditional) -->
	<?php if ( 'registered' !== $gotasale_reg_state ) : ?>
		<div class="gotasale-registration-warning" id="gotasale-registration-warning">
			<div class="gotasale-registration-warning__content">
				<span class="gotasale-registration-warning__icon">&#9888;</span>
				<div class="gotasale-registration-warning__text">
					<?php esc_html_e( 'Your store is not registered with the Got A Sale server. Notifications will not work until registration completes.', 'got-a-sale' ); ?>
					<?php if ( ! empty( $gotasale_registration_status['error'] ) ) : ?>
						<small><?php echo esc_html( $gotasale_registration_status['error'] ); ?></small>
					<?php endif; ?>
					<?php if ( ! empty( $gotasale_registration_status['attempts'] ) ) : ?>
						<small><?php
						/* translators: %d: number of registration attempts */
						printf( esc_html__( 'Attempts: %d', 'got-a-sale' ), (int) $gotasale_registration_status['attempts'] );
						?></small>
					<?php endif; ?>
				</div>
			</div>
			<button type="button" class="gotasale-btn gotasale-btn--primary gotasale-btn--sm" id="gotasale-retry-registration">
				<?php esc_html_e( 'Retry Now', 'got-a-sale' ); ?>
			</button>
		</div>
	<?php endif; ?>

	<!-- 3. Destinations Card -->
	<div class="gotasale-card">
		<div class="gotasale-card__header">
			<h2 class="gotasale-card__title"><?php esc_html_e( 'Destinations', 'got-a-sale' ); ?></h2>
		</div>

		<div id="gotasale-channel-list" class="gotasale-channel-list">
			<div class="gotasale-loading"><?php esc_html_e( 'Loading destinations...', 'got-a-sale' ); ?></div>
		</div>

		<div id="gotasale-empty-state" class="gotasale-empty-state" style="display:none;">
			<p><?php esc_html_e( 'No destinations linked yet.', 'got-a-sale' ); ?></p>
			<p><?php
				printf(
					/* translators: %s: bot command example */
					esc_html__( 'Send %s to @gotasale_bot on Telegram to get started.', 'got-a-sale' ),
					'<code>/start ' . esc_html( $gotasale_site_token ) . '</code>'
				);
			?></p>
		</div>

	</div>

	<!-- 5. Pending Link Requests Card -->
	<div class="gotasale-card">
		<div class="gotasale-card__header">
			<h2 class="gotasale-card__title"><?php esc_html_e( 'Pending Link Requests', 'got-a-sale' ); ?></h2>
			<button type="button" class="gotasale-btn gotasale-btn--ghost gotasale-btn--sm" id="gotasale-refresh-pending" title="<?php esc_attr_e( 'Refresh', 'got-a-sale' ); ?>">&#8635; <?php esc_html_e( 'Refresh', 'got-a-sale' ); ?></button>
		</div>
		<p class="gotasale-card__description">
			<?php esc_html_e( 'When someone uses /start in Telegram, /link in Discord, /gotasale link in Slack, @gotasale link in Teams, or /gotasale link in Google Chat, a confirmation code is generated. Approve the request here to complete the link.', 'got-a-sale' ); ?>
		</p>

		<div id="gotasale-pending-list" class="gotasale-pending-list">
			<div class="gotasale-loading"><?php esc_html_e( 'Loading...', 'got-a-sale' ); ?></div>
		</div>

		<div id="gotasale-pending-empty" class="gotasale-empty-state" style="display:none;">
			<p><?php esc_html_e( 'No pending link requests.', 'got-a-sale' ); ?></p>
		</div>
	</div>

	<!-- 6. Connection Card -->
	<div class="gotasale-card">
		<div class="gotasale-card__header">
			<h2 class="gotasale-card__title"><?php esc_html_e( 'Connection', 'got-a-sale' ); ?></h2>
		</div>

		<p class="gotasale-card__description"><?php esc_html_e( 'Your Site Token', 'got-a-sale' ); ?></p>
		<div class="gotasale-token-display">
			<div class="gotasale-token-value" id="gotasale-site-token"><?php echo esc_html( $gotasale_site_token ); ?></div>
			<button type="button" class="gotasale-btn gotasale-btn--ghost gotasale-btn--sm gotasale-token-copy" id="gotasale-copy-token">
				<?php esc_html_e( 'Copy', 'got-a-sale' ); ?>
			</button>
		</div>

		<!-- How to Connect guides (collapsible) -->
		<details class="gotasale-accordion">
			<summary class="gotasale-accordion__trigger">
				<?php esc_html_e( 'How to Connect', 'got-a-sale' ); ?> <span class="gotasale-accordion__icon">&#9660;</span>
			</summary>
			<div class="gotasale-connect-guide">
				<!-- Telegram -->
				<div class="gotasale-connect-guide__section">
					<div class="gotasale-connect-guide__header">
						<span class="gotasale-platform-badge gotasale-platform-badge--telegram"><?php esc_html_e( 'Telegram', 'got-a-sale' ); ?></span>
					</div>
					<ol class="gotasale-connect-steps">
						<li><?php esc_html_e( 'Open @gotasale_bot on Telegram', 'got-a-sale' ); ?></li>
						<li>
							<?php esc_html_e( 'Send this command:', 'got-a-sale' ); ?>
							<div class="gotasale-connect-command">
								<code>/start <?php echo esc_html( $gotasale_site_token ); ?></code>
								<button type="button" class="gotasale-btn gotasale-btn--ghost gotasale-btn--sm gotasale-copy-command"><?php esc_html_e( 'Copy', 'got-a-sale' ); ?></button>
							</div>
						</li>
						<li><?php esc_html_e( 'Come back here and approve the link request above', 'got-a-sale' ); ?></li>
					</ol>
				</div>

				<!-- Discord -->
				<div class="gotasale-connect-guide__section">
					<div class="gotasale-connect-guide__header">
						<span class="gotasale-platform-badge gotasale-platform-badge--discord"><?php esc_html_e( 'Discord', 'got-a-sale' ); ?></span>
					</div>
					<ol class="gotasale-connect-steps">
						<li>
							<?php esc_html_e( 'Add @gotasale_bot to your Discord server:', 'got-a-sale' ); ?>
							<a href="https://discord.com/oauth2/authorize?client_id=1470890541058228497&permissions=19456&scope=bot%20applications.commands" target="_blank" rel="noopener noreferrer" class="gotasale-btn gotasale-btn--primary gotasale-btn--sm" style="margin-left: 8px; display: inline-flex; text-decoration: none;"><?php esc_html_e( 'Invite Bot', 'got-a-sale' ); ?> &rarr;</a>
						</li>
						<li>
							<?php esc_html_e( 'In any channel, send:', 'got-a-sale' ); ?>
							<div class="gotasale-connect-command">
								<code>/link <?php echo esc_html( $gotasale_site_token ); ?></code>
								<button type="button" class="gotasale-btn gotasale-btn--ghost gotasale-btn--sm gotasale-copy-command"><?php esc_html_e( 'Copy', 'got-a-sale' ); ?></button>
							</div>
						</li>
						<li><?php esc_html_e( 'Come back here and approve the link request above', 'got-a-sale' ); ?></li>
					</ol>
				</div>

				<!-- Slack -->
				<div class="gotasale-connect-guide__section">
					<div class="gotasale-connect-guide__header">
						<span class="gotasale-platform-badge gotasale-platform-badge--slack"><?php esc_html_e( 'Slack', 'got-a-sale' ); ?></span>
					</div>
					<ol class="gotasale-connect-steps">
						<li>
							<?php esc_html_e( 'Install the gotasale app to your workspace:', 'got-a-sale' ); ?>
							<a href="https://api.gotasale.io/webhooks/slack/install" target="_blank" rel="noopener noreferrer" class="gotasale-btn gotasale-btn--primary gotasale-btn--sm" style="margin-left: 8px; display: inline-flex; text-decoration: none;"><?php esc_html_e( 'Add to Slack', 'got-a-sale' ); ?> &rarr;</a>
						</li>
						<li>
							<?php esc_html_e( 'In any channel, send:', 'got-a-sale' ); ?>
							<div class="gotasale-connect-command">
								<code>/gotasale link <?php echo esc_html( $gotasale_site_token ); ?></code>
								<button type="button" class="gotasale-btn gotasale-btn--ghost gotasale-btn--sm gotasale-copy-command"><?php esc_html_e( 'Copy', 'got-a-sale' ); ?></button>
							</div>
						</li>
						<li><?php esc_html_e( 'Come back here and approve the link request above', 'got-a-sale' ); ?></li>
					</ol>
				</div>

				<!-- Microsoft Teams -->
				<div class="gotasale-connect-guide__section">
					<div class="gotasale-connect-guide__header">
						<span class="gotasale-platform-badge gotasale-platform-badge--teams"><?php esc_html_e( 'Microsoft Teams', 'got-a-sale' ); ?></span>
					</div>
					<ol class="gotasale-connect-steps">
						<li>
							<?php esc_html_e( 'Install the gotasale app to your Teams workspace:', 'got-a-sale' ); ?>
							<a href="https://api.gotasale.io/webhooks/teams/install" target="_blank" rel="noopener noreferrer" class="gotasale-btn gotasale-btn--primary gotasale-btn--sm" style="margin-left: 8px; display: inline-flex; text-decoration: none;"><?php esc_html_e( 'Add to Teams', 'got-a-sale' ); ?> &rarr;</a>
						</li>
						<li>
							<?php esc_html_e( 'In any channel, mention the bot:', 'got-a-sale' ); ?>
							<div class="gotasale-connect-command">
								<code>@gotasale link <?php echo esc_html( $gotasale_site_token ); ?></code>
								<button type="button" class="gotasale-btn gotasale-btn--ghost gotasale-btn--sm gotasale-copy-command"><?php esc_html_e( 'Copy', 'got-a-sale' ); ?></button>
							</div>
						</li>
						<li><?php esc_html_e( 'Come back here and approve the link request above', 'got-a-sale' ); ?></li>
					</ol>
				</div>

				<!-- Google Chat -->
				<div class="gotasale-connect-guide__section">
					<div class="gotasale-connect-guide__header">
						<span class="gotasale-platform-badge gotasale-platform-badge--gchat"><?php esc_html_e( 'Google Chat', 'got-a-sale' ); ?></span>
					</div>
					<ol class="gotasale-connect-steps">
						<li>
							<?php esc_html_e( 'Install the gotasale app to your Google Workspace:', 'got-a-sale' ); ?>
							<a href="https://api.gotasale.io/webhooks/gchat/install" target="_blank" rel="noopener noreferrer" class="gotasale-btn gotasale-btn--primary gotasale-btn--sm" style="margin-left: 8px; display: inline-flex; text-decoration: none;"><?php esc_html_e( 'Add to Google Chat', 'got-a-sale' ); ?> &rarr;</a>
						</li>
						<li>
							<?php esc_html_e( 'In any space, send:', 'got-a-sale' ); ?>
							<div class="gotasale-connect-command">
								<code>/gotasale link <?php echo esc_html( $gotasale_site_token ); ?></code>
								<button type="button" class="gotasale-btn gotasale-btn--ghost gotasale-btn--sm gotasale-copy-command"><?php esc_html_e( 'Copy', 'got-a-sale' ); ?></button>
							</div>
						</li>
						<li><?php esc_html_e( 'Come back here and approve the link request above', 'got-a-sale' ); ?></li>
					</ol>
				</div>
			</div>
		</details>

	</div>

	<!-- 7. Test Notification Card -->
	<div class="gotasale-card">
		<div class="gotasale-card__header">
			<h2 class="gotasale-card__title"><?php esc_html_e( 'Test Notification', 'got-a-sale' ); ?></h2>
		</div>
		<p class="gotasale-card__description"><?php esc_html_e( 'Send a test notification to verify your bot connection.', 'got-a-sale' ); ?></p>
		<div class="gotasale-mt-md">
			<button type="button" class="gotasale-btn gotasale-btn--primary" id="gotasale-send-test">
				<?php esc_html_e( 'Send Test Notification', 'got-a-sale' ); ?>
			</button>
			<span id="gotasale-test-result"></span>
		</div>
	</div>

	<!-- 8. Advanced Features (Managed on Dashboard) -->
	<div class="gotasale-card">
		<div class="gotasale-card__header">
			<h2 class="gotasale-card__title"><?php esc_html_e( 'Advanced Features', 'got-a-sale' ); ?></h2>
		</div>
		<p class="gotasale-card__description">
			<?php esc_html_e( 'The following features are available through the Got A Sale service and can be configured on your dashboard:', 'got-a-sale' ); ?>
		</p>
		<ul class="gotasale-feature-list">
			<li><?php esc_html_e( 'Additional event types — status changes, low stock alerts, and refund notifications', 'got-a-sale' ); ?></li>
			<li><?php esc_html_e( 'Per-destination event routing — choose which events each destination receives', 'got-a-sale' ); ?></li>
			<li><?php esc_html_e( 'Payload customisation — control which data fields appear in notifications', 'got-a-sale' ); ?></li>
			<li><?php esc_html_e( 'Generic webhooks — add webhook URLs for Zapier, Make, n8n, or custom integrations', 'got-a-sale' ); ?></li>
			<li><?php esc_html_e( 'Attach destinations — share destinations across multiple stores', 'got-a-sale' ); ?></li>
		</ul>
		<div class="gotasale-mt-md">
			<a href="<?php echo esc_url( GOTASALE_LANDING_URL . '/dashboard' ); ?>" class="gotasale-btn gotasale-btn--primary" target="_blank" rel="noopener noreferrer">
				<?php esc_html_e( 'Open Dashboard', 'got-a-sale' ); ?> &rarr;
			</a>
		</div>
	</div>

	<!-- 9. Plan & Pricing -->
	<div class="gotasale-card">
		<div class="gotasale-card__header">
			<h2 class="gotasale-card__title"><?php esc_html_e( 'Plan & Pricing', 'got-a-sale' ); ?></h2>
			<div class="gotasale-card__header-actions">
				<a href="<?php echo esc_url( GOTASALE_LANDING_URL . '/dashboard' ); ?>" class="gotasale-btn gotasale-btn--ghost gotasale-btn--sm" target="_blank" rel="noopener noreferrer">
					<?php esc_html_e( 'Manage on gotasale.io', 'got-a-sale' ); ?> &rarr;
				</a>
			</div>
		</div>

		<?php if ( 'free' === $gotasale_tier ) : ?>
		<div class="gotasale-pricing-grid">
			<!-- Free Tier -->
			<div class="gotasale-pricing-tier gotasale-pricing-tier--current">
				<div class="gotasale-pricing-tier__name"><?php esc_html_e( 'Free', 'got-a-sale' ); ?></div>
				<div class="gotasale-pricing-tier__price">$0</div>
				<div class="gotasale-pricing-tier__yearly"><?php esc_html_e( 'Free forever', 'got-a-sale' ); ?></div>
				<ul class="gotasale-pricing-tier__features">
					<li><?php esc_html_e( '1 destination', 'got-a-sale' ); ?></li>
					<li><?php esc_html_e( '1 store', 'got-a-sale' ); ?></li>
					<li><?php esc_html_e( 'New order notifications', 'got-a-sale' ); ?></li>
					<li><?php esc_html_e( 'Telegram, Discord, Slack, Teams & Google Chat', 'got-a-sale' ); ?></li>
				</ul>
				<div class="gotasale-pricing-tier__action">
					<span class="gotasale-pricing-current-badge"><?php esc_html_e( 'Current Plan', 'got-a-sale' ); ?></span>
				</div>
			</div>

			<!-- Pro Tier -->
			<div class="gotasale-pricing-tier gotasale-pricing-tier--popular">
				<span class="gotasale-pricing-popular-tag"><?php esc_html_e( 'Popular', 'got-a-sale' ); ?></span>
				<div class="gotasale-pricing-tier__name"><?php esc_html_e( 'Pro', 'got-a-sale' ); ?></div>
				<div class="gotasale-pricing-tier__price">$2.50 <span>/<?php esc_html_e( 'mo', 'got-a-sale' ); ?></span></div>
				<div class="gotasale-pricing-tier__yearly"><?php esc_html_e( 'or $25/year (save 17%)', 'got-a-sale' ); ?></div>
				<ul class="gotasale-pricing-tier__features">
					<li><?php esc_html_e( '10 destinations', 'got-a-sale' ); ?></li>
					<li><?php esc_html_e( '3 stores', 'got-a-sale' ); ?></li>
					<li><?php esc_html_e( 'All events (status, low stock, refund)', 'got-a-sale' ); ?></li>
					<li><?php esc_html_e( 'Telegram, Discord, Slack, Teams, Google Chat & Webhooks', 'got-a-sale' ); ?></li>
					<li><?php esc_html_e( 'Payload customization', 'got-a-sale' ); ?></li>
					<li><?php esc_html_e( 'Per-destination routing', 'got-a-sale' ); ?></li>
				</ul>
				<div class="gotasale-pricing-tier__action gotasale-pricing-tier__action--dual">
					<a href="#" class="gotasale-btn gotasale-btn--primary gotasale-checkout-btn" data-tier="pro" data-interval="month">
						<?php esc_html_e( 'Monthly $2.50/mo', 'got-a-sale' ); ?>
					</a>
					<a href="#" class="gotasale-btn gotasale-btn--secondary gotasale-checkout-btn" data-tier="pro" data-interval="year">
						<?php esc_html_e( 'Yearly $25/yr', 'got-a-sale' ); ?> <span class="gotasale-save-tag"><?php esc_html_e( 'Save 17%', 'got-a-sale' ); ?></span>
					</a>
				</div>
			</div>

			<!-- Agency Tier -->
			<div class="gotasale-pricing-tier">
				<div class="gotasale-pricing-tier__name"><?php esc_html_e( 'Agency', 'got-a-sale' ); ?></div>
				<div class="gotasale-pricing-tier__price">$9 <span>/<?php esc_html_e( 'mo', 'got-a-sale' ); ?></span></div>
				<div class="gotasale-pricing-tier__yearly"><?php esc_html_e( 'or $49/year (save 55%)', 'got-a-sale' ); ?></div>
				<ul class="gotasale-pricing-tier__features">
					<li><?php esc_html_e( 'Unlimited destinations', 'got-a-sale' ); ?></li>
					<li><?php esc_html_e( 'Unlimited stores', 'got-a-sale' ); ?></li>
					<li><?php esc_html_e( 'All events (status, low stock, refund)', 'got-a-sale' ); ?></li>
					<li><?php esc_html_e( 'Telegram, Discord, Slack, Teams, Google Chat & Webhooks', 'got-a-sale' ); ?></li>
					<li><?php esc_html_e( 'Payload customization', 'got-a-sale' ); ?></li>
					<li><?php esc_html_e( 'Per-destination routing', 'got-a-sale' ); ?></li>
				</ul>
				<div class="gotasale-pricing-tier__action gotasale-pricing-tier__action--dual">
					<a href="#" class="gotasale-btn gotasale-btn--primary gotasale-checkout-btn" data-tier="agency" data-interval="month">
						<?php esc_html_e( 'Monthly $9/mo', 'got-a-sale' ); ?>
					</a>
					<a href="#" class="gotasale-btn gotasale-btn--secondary gotasale-checkout-btn" data-tier="agency" data-interval="year">
						<?php esc_html_e( 'Yearly $49/yr', 'got-a-sale' ); ?> <span class="gotasale-save-tag"><?php esc_html_e( 'Save 55%', 'got-a-sale' ); ?></span>
					</a>
				</div>
			</div>
		</div>
		<?php else : ?>
		<!-- Compact plan summary for paid users -->
		<div class="gotasale-plan-summary" style="display: flex; align-items: center; gap: 1rem; padding: 1rem; border-radius: 8px; background: rgba(12,245,156,0.08); border: 1px solid rgba(12,245,156,0.2);">
			<span class="gotasale-tier-badge gotasale-tier-badge--<?php echo esc_attr( $gotasale_tier ); ?>" style="font-size: 1rem; padding: 0.35rem 1rem;">
				<?php echo esc_html( ucfirst( $gotasale_tier ) ); ?> <?php esc_html_e( 'Plan', 'got-a-sale' ); ?>
			</span>
			<span style="flex: 1; opacity: 0.7; font-size: 13px;">
				<?php if ( 'pro' === $gotasale_tier ) : ?>
					<?php esc_html_e( '10 destinations, 3 stores, all events, webhooks, per-destination routing', 'got-a-sale' ); ?>
				<?php elseif ( 'agency' === $gotasale_tier ) : ?>
					<?php esc_html_e( 'Unlimited destinations & stores, all events, webhooks, per-destination routing', 'got-a-sale' ); ?>
				<?php endif; ?>
			</span>
		</div>
		<?php endif; ?>

		<!-- License Key -->
		<div class="gotasale-license-field" style="margin-top: 1rem;">
			<label for="gotasale-license-key"><?php esc_html_e( 'License Key', 'got-a-sale' ); ?></label>
			<?php if ( ! empty( $gotasale_license_key ) ) : ?>
				<?php
				$gotasale_masked = substr( $gotasale_license_key, 0, 3 ) . str_repeat( '*', max( 0, strlen( $gotasale_license_key ) - 7 ) ) . substr( $gotasale_license_key, -4 );
				?>
				<div class="gotasale-license-row" style="align-items: center;">
					<code style="flex: 1; padding: 8px 12px; border-radius: 6px; background: var(--bg-secondary, rgba(255,255,255,0.05)); font-size: 14px; letter-spacing: 0.5px;"><?php echo esc_html( $gotasale_masked ); ?></code>
					<span class="gotasale-pricing-current-badge" style="white-space: nowrap; width: auto; padding: 8px 16px;"><?php esc_html_e( 'Active', 'got-a-sale' ); ?></span>
					<button type="button" class="gotasale-btn gotasale-btn--ghost gotasale-btn--sm" id="gotasale-unlink-license"><?php esc_html_e( 'Unlink', 'got-a-sale' ); ?></button>
				</div>
				<span id="gotasale-license-result" class="gotasale-mt-sm" style="font-size:13px;"></span>
			<?php else : ?>
				<div class="gotasale-license-row">
					<input type="text" id="gotasale-license-key" name="gotasale_license_key" value="" placeholder="GS-XXXX-XXXX-XXXX-XXXX" />
					<button type="button" class="gotasale-btn gotasale-btn--primary gotasale-btn--sm" id="gotasale-activate-license">
						<?php esc_html_e( 'Activate', 'got-a-sale' ); ?>
					</button>
				</div>
				<span id="gotasale-license-result" class="gotasale-mt-sm" style="font-size:13px;"></span>
				<p class="gotasale-card__description gotasale-mt-sm"><?php esc_html_e( 'Enter your license key to link this store to your Got A Sale account and activate your paid plan.', 'got-a-sale' ); ?></p>
			<?php endif; ?>
		</div>
	</div>

	</div><!-- .gotasale-settings -->
</div><!-- .wrap -->
